/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.test.generatedkeys.seqidentity;

import org.junit.Test;

import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Oracle9iDialect;
import org.hibernate.testing.RequiresDialect;
import org.hibernate.testing.junit4.BaseCoreFunctionalTestCase;

import static org.junit.Assert.assertNotNull;
/**
 * @author Steve Ebersole
 */
@RequiresDialect( Oracle9iDialect.class )
public class SequenceIdentityTest extends BaseCoreFunctionalTestCase {
	public void configure(Configuration cfg) {
		//this test makes no sense w/o the following property enabled
		//note : this property is set to false by default in Oracle9iDialect
		//but if this property is set to false, then the AssertionFailure will
		//be thrown by {@link org.hibernate.engine.jdbc.internal.StatementPreparerImpl.checkAutoGeneratedKeysSupportEnabled()}
		//so let just change this here and this should be invested deeper.
		cfg.setProperty( Environment.USE_GET_GENERATED_KEYS, "true" );
	}

	public String[] getMappings() {
		return new String[] { "generatedkeys/seqidentity/MyEntity.hbm.xml" };
	}

	@Test
	public void testSequenceIdentityGenerator() {
		Session session = openSession();
		session.beginTransaction();

		MyEntity e = new MyEntity( "entity-1" );
		session.save( e );

		// this insert should happen immediately!
		assertNotNull( "id not generated through forced insertion", e.getId() );

		session.delete( e );
		session.getTransaction().commit();
		session.close();
	}
}
