package org.hibernate.envers.test.integration.ids.embeddedid;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;

import org.hibernate.envers.Audited;

/**
 * @author Lukasz Antoniak (lukasz dot antoniak at gmail dot com)
 */
@Entity
@Audited
public class Producer implements Serializable {
	@Id
	@Column(name = "id")
	private Integer id;

	@Column(name = "name")
	private String name;

	public Producer() {
	}

	public Producer(Integer id, String name) {
		this.id = id;
		this.name = name;
	}

	@Override
	public boolean equals(Object o) {
		if ( this == o ) {
			return true;
		}
		if ( !(o instanceof Producer) ) {
			return false;
		}

		Producer producer = (Producer) o;

		if ( getId() != null ? !getId().equals( producer.getId() ) : producer.getId() != null ) {
			return false;
		}
		if ( getName() != null ? !getName().equals( producer.getName() ) : producer.getName() != null ) {
			return false;
		}

		return true;
	}

	@Override
	public int hashCode() {
		int result = id != null ? id.hashCode() : 0;
		result = 31 * result + (name != null ? name.hashCode() : 0);
		return result;
	}

	@Override
	public String toString() {
		return "Producer(id = " + id + ", name = " + name + ")";
	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
}