package org.hibernate.test.mapping;

import static javax.persistence.CascadeType.ALL;
import static javax.persistence.FetchType.EAGER;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;

@Entity
@Table(name = "USERTABLE")
public class UserEntity implements Serializable{

	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue
	@Column(name = "user_id")
	private Long id;

	@OrderColumn(name = "cnf_order")
	@OneToMany(mappedBy="user", fetch = EAGER, cascade = ALL, orphanRemoval = true)
	private Set<UserConfEntity> confs =  new HashSet<UserConfEntity>();
	
	private String name;
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Set<UserConfEntity> getConfs() {
		return confs;
	}

	public void setConfs(Set<UserConfEntity> confs) {
		this.confs = confs;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
}
