/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2010, Red Hat Middleware LLC or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Middleware LLC.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 *
 */
package org.hibernate.test.annotations.manytomany;

import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;

/**
 * Many to many tests using max_fetch_depth == 0
 *
 * @author Gail Badner
 */
@SuppressWarnings("unchecked")
public class ManyToManyMaxFetchDepth0Test extends ManyToManyTest {
	@Override
	protected void configure(Configuration cfg) {
		cfg.setProperty( Environment.MAX_FETCH_DEPTH, "0" );
		super.configure( cfg );
	}
}
