/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.FactoryFinderInstance;
import javax.faces.ServletContextFacesContextFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

final class CurrentThreadToServletContext {
    ConcurrentMap<FactoryManagerCacheKey, FactoryFinderInstance> applicationMap = new ConcurrentHashMap<FactoryManagerCacheKey, FactoryFinderInstance>();
    private AtomicBoolean logNullFacesContext = new AtomicBoolean(false);
    private AtomicBoolean logNonNullFacesContext = new AtomicBoolean(false);
    private final ServletContextFacesContextFactory servletContextFacesContextFactory = new ServletContextFacesContextFactory();
    private static final Logger LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");

    CurrentThreadToServletContext() {
    }

    Object getFallbackFactory(FactoryFinderInstance brokenFactoryManager, String factoryName) {
        Object result = null;
        ClassLoader cl = this.getClassLoader();
        for (Map.Entry cur : this.applicationMap.entrySet()) {
            if (((FactoryManagerCacheKey)cur.getKey()).getClassLoader().equals(cl) && !((FactoryFinderInstance)cur.getValue()).equals(brokenFactoryManager) && null != (result = ((FactoryFinderInstance)cur.getValue()).getFactory(factoryName))) break;
        }
        return result;
    }

    FactoryFinderInstance getApplicationFactoryManager() {
        ClassLoader cl = this.getClassLoader();
        FactoryFinderInstance result = this.getApplicationFactoryManager(cl, true);
        return result;
    }

    FactoryFinderInstance getApplicationFactoryManager(boolean create) {
        ClassLoader cl = this.getClassLoader();
        FactoryFinderInstance result = this.getApplicationFactoryManager(cl, create);
        return result;
    }

    private FactoryFinderInstance getApplicationFactoryManager(ClassLoader cl, boolean create) {
        FacesContext facesContext = this.servletContextFacesContextFactory.getFacesContextWithoutServletContextLookup();
        boolean isSpecialInitializationCase = this.detectSpecialInitializationCase(facesContext);
        FactoryManagerCacheKey key = new FactoryManagerCacheKey(facesContext, cl, this.applicationMap);
        FactoryFinderInstance result = (FactoryFinderInstance)this.applicationMap.get(key);
        FactoryFinderInstance toCopy = null;
        if (result == null && create) {
            boolean createNewFactoryManagerInstance = false;
            if (isSpecialInitializationCase) {
                boolean classLoadersMatchButContextsDoNotMatch = false;
                boolean foundNoMatchInApplicationMap = true;
                for (Map.Entry cur : this.applicationMap.entrySet()) {
                    FactoryManagerCacheKey curKey = (FactoryManagerCacheKey)cur.getKey();
                    if (!curKey.getClassLoader().equals(cl)) continue;
                    foundNoMatchInApplicationMap = false;
                    if (null != key.getContext() && null != curKey.getContext() && !key.getContext().equals(curKey.getContext())) {
                        classLoadersMatchButContextsDoNotMatch = true;
                        toCopy = (FactoryFinderInstance)cur.getValue();
                        break;
                    }
                    result = (FactoryFinderInstance)cur.getValue();
                    break;
                }
                createNewFactoryManagerInstance = foundNoMatchInApplicationMap || null == result && classLoadersMatchButContextsDoNotMatch;
            } else {
                createNewFactoryManagerInstance = true;
            }
            if (createNewFactoryManagerInstance) {
                FactoryFinderInstance newResult = null != toCopy ? new FactoryFinderInstance(toCopy) : new FactoryFinderInstance();
                result = this.applicationMap.putIfAbsent(key, newResult);
                result = null != result ? result : newResult;
            }
        }
        return result;
    }

    Object getServletContextForCurrentClassLoader() {
        FactoryManagerCacheKey key = new FactoryManagerCacheKey(null, this.getClassLoader(), this.applicationMap);
        Object result = key.getContext();
        return result;
    }

    private boolean detectSpecialInitializationCase(FacesContext facesContext) {
        boolean result = false;
        if (null == facesContext) {
            this.logNullFacesContext.compareAndSet(false, true);
        } else {
            this.logNonNullFacesContext.compareAndSet(false, true);
        }
        result = this.logNullFacesContext.get() && this.logNonNullFacesContext.get();
        return result;
    }

    void removeApplicationFactoryManager() {
        ClassLoader cl = this.getClassLoader();
        FactoryFinderInstance fm = this.getApplicationFactoryManager(cl, false);
        if (null != fm) {
            fm.clearInjectionProvider();
        }
        FacesContext facesContext = this.servletContextFacesContextFactory.getFacesContextWithoutServletContextLookup();
        boolean isSpecialInitializationCase = this.detectSpecialInitializationCase(facesContext);
        FactoryManagerCacheKey key = new FactoryManagerCacheKey(facesContext, cl, this.applicationMap);
        this.applicationMap.remove(key);
        if (isSpecialInitializationCase) {
            this.logNullFacesContext.set(false);
            this.logNonNullFacesContext.set(false);
        }
    }

    void resetSpecialInitializationCaseFlags() {
        this.logNullFacesContext.set(false);
        this.logNonNullFacesContext.set(false);
    }

    private ClassLoader getClassLoader() throws FacesException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            throw new FacesException("getContextClassLoader");
        }
        return cl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FactoryManagerCacheKey {
        private ClassLoader cl;
        private Long marker;
        private Object context;
        private static final String MARKER_KEY = FactoryFinder.class.getName() + "." + FactoryManagerCacheKey.class.getSimpleName();
        private static final String INIT_TIME_CL_KEY = MARKER_KEY + ".InitTimeCLKey";

        FactoryManagerCacheKey(FacesContext facesContext, ClassLoader cl, Map<FactoryManagerCacheKey, FactoryFinderInstance> factoryMap) {
            Object servletContext;
            ExternalContext extContext = null != facesContext ? facesContext.getExternalContext() : null;
            Object object = servletContext = null != extContext ? extContext.getContext() : null;
            if (null == facesContext || null == extContext || null == servletContext) {
                this.initFromFactoryMap(cl, factoryMap);
            } else {
                this.initFromAppMap(extContext, cl);
            }
        }

        private void initFromFactoryMap(ClassLoader cl, Map<FactoryManagerCacheKey, FactoryFinderInstance> factoryMap) {
            Set<FactoryManagerCacheKey> keys = factoryMap.keySet();
            FactoryManagerCacheKey matchingKey = null;
            if (keys.isEmpty()) {
                this.cl = cl;
                this.marker = new Long(System.currentTimeMillis());
            } else {
                for (FactoryManagerCacheKey currentKey : keys) {
                    assert (null != currentKey.cl);
                    ClassLoader matchingCL = this.findMatchConsideringParentClassLoader(cl, currentKey.cl);
                    if (null == matchingCL) continue;
                    if (null != matchingKey) break;
                    matchingKey = currentKey;
                    this.cl = matchingCL;
                }
                if (null != matchingKey) {
                    this.marker = matchingKey.marker;
                    this.context = matchingKey.context;
                }
            }
        }

        private ClassLoader findMatchConsideringParentClassLoader(ClassLoader argumentCL, ClassLoader currentKeyCL) {
            for (ClassLoader curCL = argumentCL; null != curCL; curCL = curCL.getParent()) {
                if (!curCL.equals(currentKeyCL)) continue;
                return curCL;
            }
            return null;
        }

        private void initFromAppMap(ExternalContext extContext, ClassLoader cl) {
            Map<String, Object> appMap = extContext.getApplicationMap();
            Long val = (Long)appMap.get(MARKER_KEY);
            if (null == val) {
                this.marker = new Long(System.currentTimeMillis());
                appMap.put(MARKER_KEY, this.marker);
                appMap.put(INIT_TIME_CL_KEY, new Integer(System.identityHashCode(cl)));
            } else {
                this.marker = val;
            }
            this.cl = this.resolveToFirstTimeUsedClassLoader(cl, extContext);
            this.context = extContext.getContext();
        }

        private ClassLoader resolveToFirstTimeUsedClassLoader(ClassLoader toResolve, ExternalContext extContext) {
            ClassLoader curCL = toResolve;
            ClassLoader resolved = null;
            Map<String, Object> appMap = extContext.getApplicationMap();
            Integer webAppCLHashCode = (Integer)appMap.get(INIT_TIME_CL_KEY);
            boolean found = false;
            if (null != webAppCLHashCode) {
                int toResolveHashCode = System.identityHashCode(curCL);
                while (!found && null != curCL) {
                    found = toResolveHashCode == webAppCLHashCode;
                    if (found) continue;
                    curCL = curCL.getParent();
                    toResolveHashCode = System.identityHashCode(curCL);
                }
            }
            resolved = found ? curCL : toResolve;
            return resolved;
        }

        ClassLoader getClassLoader() {
            return this.cl;
        }

        Object getContext() {
            return this.context;
        }

        private FactoryManagerCacheKey() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FactoryManagerCacheKey other = (FactoryManagerCacheKey)obj;
            if (!(this.cl == other.cl || this.cl != null && this.cl.equals(other.cl))) {
                return false;
            }
            return this.marker == other.marker || this.marker != null && this.marker.equals(other.marker);
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + (this.cl != null ? this.cl.hashCode() : 0);
            hash = 97 * hash + (this.marker != null ? this.marker.hashCode() : 0);
            return hash;
        }
    }
}

