/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import java.awt.Point;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextReplacedElement;
import org.xhtmlrenderer.render.BlockBox;

public abstract class AbstractFormField
implements ITextReplacedElement {
    protected static final String DEFAULT_CHECKED_STATE = "Yes";
    protected static final String OFF_STATE = "Off";
    private static final float FONT_SIZE_ADJUSTMENT = 0.8f;
    private int _x;
    private int _y;
    private int _width;
    private int _height;
    private String _fieldName;

    protected abstract String getFieldType();

    protected int getX() {
        return this._x;
    }

    protected void setX(int x) {
        this._x = x;
    }

    protected int getY() {
        return this._y;
    }

    protected void setY(int y) {
        this._y = y;
    }

    protected int getWidth() {
        return this._width;
    }

    protected void setWidth(int width) {
        this._width = width;
    }

    protected int getHeight() {
        return this._height;
    }

    protected void setHeight(int height) {
        this._height = height;
    }

    protected String getFieldName(ITextOutputDevice outputDevice, Element e) {
        if (this._fieldName == null) {
            String result = e.getAttribute("name");
            this._fieldName = result.equals("") ? this.getFieldType() + outputDevice.getNextFormFieldIndex() : result;
        }
        return this._fieldName;
    }

    protected String getValue(Element e) {
        String result = e.getAttribute("value");
        if (result.equals("")) {
            return DEFAULT_CHECKED_STATE;
        }
        return result;
    }

    protected boolean isChecked(Element e) {
        return !e.getAttribute("checked").equals("");
    }

    protected boolean isReadOnly(Element e) {
        return !e.getAttribute("readonly").equals("");
    }

    protected boolean isSelected(Element e) {
        return !e.getAttribute("selected").equals("");
    }

    public void detach(LayoutContext c) {
    }

    public int getIntrinsicHeight() {
        return this.getHeight();
    }

    public int getIntrinsicWidth() {
        return this.getWidth();
    }

    public Point getLocation() {
        return new Point(this.getX(), this.getY());
    }

    public boolean isRequiresInteractivePaint() {
        return false;
    }

    public void setLocation(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    protected void initDimensions(LayoutContext c, BlockBox box, int cssWidth, int cssHeight) {
        if (cssWidth != -1) {
            this.setWidth(cssWidth);
        } else if (cssHeight != -1) {
            this.setWidth(cssHeight);
        } else {
            this.setWidth((int)(box.getStyle().getFont((CssContext)c).size * 0.8f));
        }
        if (cssHeight != -1) {
            this.setHeight(cssHeight);
        } else if (cssWidth != -1) {
            this.setHeight(cssWidth);
        } else {
            this.setHeight((int)(box.getStyle().getFont((CssContext)c).size * 0.8f));
        }
    }

    protected String spaces(int count) {
        StringBuffer result = new StringBuffer(count);
        for (int i = 0; i < count; ++i) {
            result.append(' ');
        }
        return result.toString();
    }
}

