/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.style.derived;

import java.awt.Color;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.parser.PropertyValue;
import org.xhtmlrenderer.css.style.DerivedValue;

public class ColorValue
extends DerivedValue {
    public static final Color COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    private Color _derivedColor;

    public ColorValue(CSSName name, PropertyValue value) {
        super(name, value.getPrimitiveType(), value.getCssText(), value.getCssText());
        this._derivedColor = value.getFSRGBColor().toAWTColor();
    }

    public Color asColor() {
        return this._derivedColor;
    }

    public static Color lightenColor(Color color) {
        if (color == null) {
            return null;
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float hBase = hsb[0];
        float sBase = hsb[1];
        float bBase = hsb[2];
        float hLighter = hBase;
        float sLighter = 0.35f * bBase * sBase;
        float bLighter = 0.6999f + 0.3f * bBase;
        return Color.getHSBColor(hLighter, sLighter, bLighter);
    }

    public static Color darkenColor(Color color) {
        if (color == null) {
            return null;
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float hBase = hsb[0];
        float sBase = hsb[1];
        float bBase = hsb[2];
        float hDarker = hBase;
        float sDarker = sBase;
        float bDarker = 0.56f * bBase;
        return Color.getHSBColor(hDarker, sDarker, bDarker);
    }
}

